/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.SchoolMember;

/**
 * This is the handler class for instance id constraints included
 * in item templates.  Adopters can either provide a direct implementation of
 * IItemConstraintHandler or extend AbstractItemConstraintHandler
 */
public class ItemInstanceIdHandler extends AbstractItemConstraintHandler
{		
	@Override
	protected INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException
	{
		INodes result = QueryOutputArtifactFactory.getInstance().createNodes(context.getId()); 
		IInstanceIdConstraint instanceIdConstraint = (IInstanceIdConstraint)constraint;
		IInstanceId[] instanceIds = instanceIdConstraint.getInstanceIds();
		for (int i = 0; i < instanceIds.length; i++) {
			if (!XMLRepository.MDR_ID.equals(instanceIds[i].getMdrId()
					.toString())) {
				continue;
			}
			String localId = instanceIds[i].getLocalId().toString();
			XMLRepository repo = (XMLRepository) getValue(ICMDBfSampleConstants.DATA_PROVIDER);
			// Traverse the students
			traverseSchoolMembers(result, localId, repo.students);
			// Traverse the teachers
			traverseSchoolMembers(result, localId, repo.teachers);
			// Traverse the classes
			for (int j = 0; j < repo.classes.length; j++) {
				if (localId.equals(repo.classes[j].courseCode)) {
					// TODO Should this be result.addItem(...)???
					context.addItem(repo.classes[j]);
				}
			}
		}
		return result;
	}
	
	private void traverseSchoolMembers (INodes result, String localId, SchoolMember[] members)
	{
		for (int i = 0; i < members.length; i++)
		{
			if (localId.equals(members[i].identity.id))
			{
				result.addItem(members[i]);
			}
		}
	}
}
