/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.ClassSession;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.SchoolMember;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.Student;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.Teacher;

/**
 * This is the handler for the record type constraint specified in 
 * and item template.  Adopters can either extend AbstractItemConstraintHandler
 * or provide a direct implementation of {@link IItemConstraintHandler}
 * 
 * @author Ali Mehregani
 */
public class ItemRecordTypeHandler extends AbstractItemConstraintHandler
{
	/**
	 * Record type representing student
	 */
	private static final String RECORD_TYPE_STUDENT = "student";
	
	/**
	 * Record type representing teacher
	 */
	private static final String RECORD_TYPE_TEACHER = "teacher";
	
	/**
	 * Record type representing class
	 */
	private static final String RECORD_TYPE_CLASS = "class";
	

	@Override
	protected INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException
	{
		IRecordType recordType = (IRecordType)constraint;
		String localName = recordType.getLocalName();
		XMLRepository repo = (XMLRepository)getValue(ICMDBfSampleConstants.DATA_PROVIDER);
		INodes result = QueryOutputArtifactFactory.getInstance().createNodes(context.getId());
		
		// If the record type constraint includes all items as its context
		if (context.isStartingContext())
		{			
			if (RECORD_TYPE_STUDENT.equals(localName))
			{
				addSchoolMembers(result, repo.students);
			}
			else if (RECORD_TYPE_TEACHER.equals(localName))
			{
				addSchoolMembers(result, repo.teachers);
			}
			else if (RECORD_TYPE_CLASS.equals(localName))
			{
				for (int i = 0; i < repo.classes.length; i++)
				{
					result.addItem(repo.classes[i]);
				}
			}
			
			return result;
		}
		
		IGraphElement[] elements = context.getElements();
		for (int i = 0; i < elements.length; i++)
		{
			IRecord[] records = elements[i].getRecords();
			for (int j = 0; j < records.length; j++)
			{
				if (RECORD_TYPE_STUDENT.equals(localName) && records[j].getValue() instanceof Student)
				{
					result.addItem((IItem)elements[i]);
					continue;	
				}
				else if (RECORD_TYPE_TEACHER.equals(localName) && records[j].getValue() instanceof Teacher)
				{
					result.addItem((IItem)elements[i]);
					continue;
				}
				else if (RECORD_TYPE_CLASS.equals(localName) && records[j].getValue() instanceof ClassSession)
				{
					result.addItem((IItem)elements[i]);
					continue;
				}
			}
		}
		
		return result;
	}

	private void addSchoolMembers(INodes result, SchoolMember[] members)
	{
		for (int i = 0; i < members.length; i++)
		{
			result.addItem(members[i]);
		}
	}
}
