/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;

public class ItemTemplateHandler extends AbstractItemTemplateHandler
{

	@Override
	protected void appendAllItems(INodes nodes) throws CMDBfServiceException
	{
		XMLRepository repo = (XMLRepository)getValue(ICMDBfSampleConstants.DATA_PROVIDER);
		addItems(nodes, repo.classes);
		addItems(nodes, repo.students);
		addItems(nodes, repo.teachers);
	}

	private void addItems(INodes nodes, IItemConvertible[] itemConvertibles)
	{
		for (int i = 0; i < itemConvertibles.length; i++)
		{
			nodes.addItem(itemConvertibles[i].toItem(nodes));
		}
	}

}
