/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandlerFactory;

/**
 * This factory class is used to create handlers for the selectors 
 * that are applicable to the XML repository MDR.  Adopters can either 
 * extend AbstractSelectorHandlerFactory or provide a direct 
 * implementation of ISelectorHandlerFactory
 */
public class QueryHandlerFactory extends AbstractQueryHandlerFactory
{
	private static QueryHandlerFactory instance;
	
	/**
	 * Make the constructor invisible
	 */
	private QueryHandlerFactory()
	{
	}
	
	public static QueryHandlerFactory getInstance()
	{
		if (instance == null)
		{
			instance = new QueryHandlerFactory();
		}
		return instance;
	}
	
	@Override
	protected IItemConstraintHandler createItemInstanceHandler()
	{	
		return new ItemInstanceIdHandler();
	}
	
	@Override
	protected IItemConstraintHandler createItemRecordHandler()
	{
		return new ItemRecordTypeHandler();
	}
	
	@Override
	protected IItemTemplateHandler createItemHandler() throws CMDBfServiceException
	{
		return new ItemTemplateHandler();
	}
	
	@Override
	protected IRelationshipTemplateHandler createRelationshipHandler() throws CMDBfServiceException
	{
		return new RelationshipTemplateHandler();
	}
}
