/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.query;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.xml.sax.SAXException;

/**
 * The main class used to run the CMDBf queries.  A set of query
 * files exist under the source directory.  Adjust the queryFile field to
 * run the correct CMDBf query. 
 */
public class QueryLauncher
{
	/**
	 * Adjust this field to run different queries.  Possible values
	 * can be:
	 * <ul>
	 *  <li>all-students.txt</li>
	 *  <li>all-teachers.txt</li>
	 *  <li>teaches-relationship.txt</li>
	 *  <li>relationship-all-classes.txt</li>
	 * </ul>
	 */
	private static final String queryFile = "teaches-relationship.txt";
	

	public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, IllegalArgumentException, URISyntaxException, CMDBfServiceException
	{	
		// Run the query
		InputStream query = QueryLauncher.class.getClassLoader().getResourceAsStream(queryFile);
		CMDBfQueryOperation queryOperation = new CMDBfQueryOperation(QueryHandlerFactory.getInstance(), null);
		Map<String, Object> init = new Hashtable<String, Object>();
		init.put(ICMDBfSampleConstants.DATA_PROVIDER, new XMLRepository());
		queryOperation.initialize(init);
		IQueryResult result = queryOperation.execute(query);
		
		// Transform and output the query
		InputStream resultStream = QueryOutputTransformer.transform(result);
		byte[] buffer = new byte[1024];
		while (resultStream.available() > 0)
		{
			int chars = resultStream.read(buffer);
			System.out.print(new String(buffer, 0, chars));
		}
	}

}
