/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.samples.cmdbf.services.query;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.ClassSession;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.Identity;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.Student;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository.Teacher;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * The XML handler for parsing the data that represents 
 * a school with students, teacher, and classes 
 */
public class SchoolXMLHandler extends DefaultHandler
{
	private Student currentStudent;
	private Teacher currentTeacher;
	private ClassSession currentClass;
	private List<Student> enrolledStudents;
	
	private Map<String, Student> students;
	private Map<String, Teacher> teachers;
	private List<ClassSession> classes;
	
	public SchoolXMLHandler()
	{
		students = new Hashtable<String, Student>();
		teachers = new Hashtable<String, Teacher>();
		classes = new ArrayList<ClassSession>();
		enrolledStudents = new ArrayList<Student>();
	}
	
	@Override
	public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException
	{
		if ("student".equals(name))
		{
			currentStudent = new Student();			
		}
		else if ("teacher".equals(name) && currentClass == null)
		{
			currentTeacher = new Teacher();			
		}
		else if ("class".equals(name))
		{
			currentClass = new ClassSession();
			currentClass.name = attributes.getValue("name");
			currentClass.courseCode = attributes.getValue("courseCode");
		}
		else if ("identity".equals(name))
		{
			Identity identity = currentStudent != null ? 
					currentStudent.identity : currentTeacher.identity;
			
			identity.firstName = attributes.getValue("firstName");
			identity.lastName = attributes.getValue("lastName");
			identity.id = attributes.getValue("id");			
		}
		else if ("enrolledStudent".equals(name))
		{			
			enrolledStudents.add(students.get(attributes.getValue("idRef")));
		}
		else if ("teacher".equals(name))
		{
			currentClass.teacher = teachers.get(attributes.getValue("idRef"));
		}
		
	}
	
	@Override
	public void endElement(String uri, String localName, String name) throws SAXException
	{
		if ("student".equals(name))
		{
			students.put(currentStudent.identity.id, currentStudent);
			currentStudent = null;
		}
		else if ("teacher".equals(name) && currentClass == null)
		{
			teachers.put(currentTeacher.identity.id, currentTeacher);
			currentTeacher = null;
		}
		else if ("class".equals(name))
		{
			currentClass.students = enrolledStudents.toArray(new Student[enrolledStudents.size()]);
			classes.add (currentClass);			
			currentClass = null;
			enrolledStudents.clear();
		}
	}
	
	public Student[] getStudents()
	{
		return students.values().toArray(new Student[students.size()]); 
	}
	
	public Teacher[] getTeachers()
	{
		return teachers.values().toArray(new Teacher[teachers.size()]);
	}
	
	public ClassSession[] getSchoolClasses()
	{
		return classes.toArray(new ClassSession[classes.size()]);
	}
}
