/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;

import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CMDBfQuery extends AbstractOutputter {
	public static final String CMDBF_QUERY="query";
	public static final String MDREPR="epr";
	
	public void render(PrintWriter output, IParameters input) throws Exception {
		String query = input.getParameter(CMDBF_QUERY);
		String mdrEPR = input.getParameter(MDREPR);
		

		if ((mdrEPR != null) && (query != null)){
			
			//get cdmbf query
			Element response = submitQuery(mdrEPR, query);
			//get current time		
			output.print(XmlUtils.toString(response));
				
		}
		

	}
	protected Element submitQuery(String mdrEPR, String query) throws Exception{
		QueryServiceClient queryService =   new QueryServiceClient(mdrEPR);
		Document doc = XmlUtils.createDocument(query);
		Element elem = doc.getDocumentElement();
	    return queryService.graphQuery(elem);
	}
	
}
