/**********************************************************************
 * Copyright (c) 2008 CA Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * CA - Initial API and implementation
 *
 **********************************************************************/

package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;

public class RecordDetailsOutputter extends AbstractOutputter {
		
	public void render(PrintWriter output, IParameters input) throws Exception {

		StringBuffer sb = new StringBuffer();
		sb.append("<?xml version=\"1.0\"?>");
		sb.append(" <xml>");

		String xmlIn = input.getParameter("xmlIn");		
		
		System.out.println("printing out xmlIn ...... "+xmlIn);
		
		sb.append(xmlIn);
		
		sb.append(" </xml>");

		System.out.println("printing out XML ...... "+sb);
		output.print(sb);
			
	}
	
}

