/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: ReportDeploymentHandler.java,v 1.2 2008/01/08 21:43:05 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * Parses the deployment report file: 
 * <pre>
 * <reports> 
 *    <report type="CBE">
 *       <template file="LogReport.rptdesign"/> 
 *    </report>
 *    <report>
 *       <template file="StatReport.rptdesign"/> 
 *    </report>
 *  </reports>
 * </pre>
 * @author sleeloy
 * 
 */
public class ReportDeploymentHandler extends DefaultHandler {

	/**
	 * Elements
	 */
	public static final String SAX_PARSER_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes"; //$NON-NLS-1$

	public static final String SAX_PARSER_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces"; //$NON-NLS-1$

	public static final String REPORT_ELEMENT = "report"; //$NON-NLS-1$

	public static final String TEMPLATE_ELEMENT = "template"; //$NON-NLS-1$

	public static final String FILE_ATTR = "file"; //$NON-NLS-1$
	
	public static final String ID_ATTR = "id"; //$NON-NLS-1$

	public static final String CAPTION_ATTR = "caption"; //$NON-NLS-1$

	public static final String TYPE_ATTR = "type"; //$NON-NLS-1$

	protected Map registry = new HashMap();
	protected Map templateLookup = new HashMap();
	protected ReportElement reportElem;

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (REPORT_ELEMENT.equals(qName)) {
			reportElem = null;
		}
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (REPORT_ELEMENT.equals(qName)) {
			//TODO: need to support lists
			reportElem = new ReportElement();
			reportElem.setType(attributes.getValue(TYPE_ATTR));
			registry.put(attributes.getValue(TYPE_ATTR), reportElem);
		} else if (TEMPLATE_ELEMENT.equals(qName)) {
			if (reportElem != null){
				reportElem.setFilename(attributes.getValue(FILE_ATTR));
				reportElem.setId(attributes.getValue(ID_ATTR));
				reportElem.setCaption(attributes.getValue(CAPTION_ATTR));
				templateLookup.put(reportElem.getId(), reportElem);
			}
		}
	}

	public void parse(String filename) {
		try {
			SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
			saxParserFactory.setNamespaceAware(false);
			saxParserFactory.setValidating(false);

			SAXParser saxParser = saxParserFactory.newSAXParser();

			saxParser.parse(new InputSource(new FileInputStream(new File(
					filename))), this);

		} catch (ParserConfigurationException e) {
			fatalError(e);
		} catch (SAXNotRecognizedException e) {
			fatalError(e);
		} catch (SAXNotSupportedException e) {
			fatalError(e);
		} catch (SAXException e) {
			fatalError(e);
		} catch (IOException e) {
			fatalError(e);
		}

	}

	protected void fatalError(Exception e) {
		e.printStackTrace();
	}

	public Map getRegistry() {
		return registry;
	}

	public Map getTemplateLookup() {
		return templateLookup;
	}
	
	
}
