/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * CA - Initial API and implementation
 *
 **********************************************************************/

package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;

import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Element;

public class ServiceMetaDataOutputter extends AbstractOutputter {
		
	public void render(PrintWriter output, IParameters input) throws Exception {		
		String mdrEPR = input.getParameter("mdr"); //$NON-NLS-1$
				
		QueryServiceClient queryService =   new QueryServiceClient(mdrEPR);
		Element result = queryService.getQueryServiceMetadata();
		
		if (result==null) 
			output.print(Messages.getString("ServiceMetaDataOutputter.1")); //$NON-NLS-1$
		else {
			output.print(XmlUtils.toString(result));
		}
			
	}
	
}

