/*******************************************************************************
 * Copyright (c) 2007,2008 CA, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.outputter;


import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.cmdbf.registration.client.RegistrationServiceClient;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.DeregistrationInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IQuery;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.RegistrationInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


public class StatusResponseOutputter extends AbstractOutputter {

	protected static final String AllQuery="<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:query xmlns:s=\"http://cmdbf.org/schema/1-0-0/datamodel\">	<s:itemTemplate id=\"all-items\">		</s:itemTemplate>		<s:relationshipTemplate id=\"all-relationships\">		<s:sourceTemplate ref=\"all-items\"/>		<s:targetTemplate ref=\"all-items\"/>	</s:relationshipTemplate></s:query>";
	
	public void render(PrintWriter output, IParameters input) throws Exception {

		boolean bRegister = true;
		
		// get deregister parameter
		String deregister = input.getParameter("deregister");
		if ( deregister != null ){
			bRegister = false;
		}

		// get CMDBf EPR parameter
		String cmdbfParm = input.getParameter("cmdbfEPR");

		// get MDR EPR parameters
		ArrayList<String> mdrliststr = new ArrayList<String>();
		for(Integer i = 0;; i++) {
			String mdrParm = input.getParameter( "mdrEPR" + i.toString() );
			if(mdrParm == null)
				break;


			mdrliststr.add( mdrParm );
		}

		
		//Here we will register all CI for a MDR.
		
		// get the federating CMDB client 
//		FederatingCMDBClient client = new FederatingCMDBClient( cmdbfEPR );

		// register everything in all the MDRs
		for (int x = 0; x < mdrliststr.size(); x++){
			String mdrEPR = mdrliststr.get(x);
			//submit the all query to the mdr
			IQueryResult graphResponse = submitQuery(mdrEPR, AllQuery);
			registerDerigisterCI(bRegister, graphResponse,cmdbfParm, output );
		}
	
		//
		// convert result XML to JSON
		//
		
	}
	
		
	public void registerDerigisterCI(boolean bRegister, IQueryResult queryResult, String cmdbfepr, PrintWriter output) throws Exception{
			
			// construct the register/deregister request
			IRegisterRequest registerRequest = RegisterInputArtifactFactory.getInstance().createRegisterRequest();			
			IDeregisterRequest deregisterRequest = DeregisterInputArtifactFactory.getInstance().createDeregisterRequest();

	 		// add the items (nodes) 
	 		INodes[] nodes = queryResult.getAllNodes();
	 		for (INodes inode: nodes){
	 			IGraphElement[] graphElements = inode.getElements();
	 			
	 			for (IGraphElement graphElement: graphElements ){
	 					 		
	 					if ( bRegister )
	 						registerRequest.addItem( (IItem) graphElement );
	 					else
	 						deregisterRequest.addItem( (IItem) graphElement );
	 			}
	 		}
	 		
	 		// add the relationships (edges) 
	 		IEdges[] edges = queryResult.getAllEdges();
			for (IEdges edge: edges){
	 			IGraphElement[] graphElements = edge.getElements();
	 			
	 			for (IGraphElement graphElement: graphElements ){
	 					if ( bRegister )
	 						registerRequest.addRelationship( (IRelationship) graphElement );
	 					else
	 						deregisterRequest.addRelationship( (IRelationship) graphElement );

	 			}
	 		}
			
			// Set a dummy mdr id
			registerRequest.setMdrId(new URI(""));
			deregisterRequest.setMdrId(new URI(""));
			
			// get Federating CMDB client using EPR
			RegistrationServiceClient client = new RegistrationServiceClient(cmdbfepr);

			Element result = null;
			
			if ( bRegister ){
				// transform POJO request to XML
				InputStream is = RegistrationInputTransformer.transform(registerRequest);
				Document regdoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
				Element regRequest = XmlUtils.getDocumentRoot( regdoc );

				// register the items/relationships from the MDR with the CMDBf
				result = client.register( regRequest );
			} else {
				// transform POJO request to XML
				InputStream is = DeregistrationInputTransformer.transform(deregisterRequest);
				Document regdoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
				Element regRequest = XmlUtils.getDocumentRoot( regdoc );

				// deregister the items/relationships from the MDR with the CMDBf
				result = client.deregister( regRequest );
			}
			
	 		// convert the result to JSON
			renderStatusResult( output, result );
			
				
		}
				
	

		protected IQueryResult submitQuery(String mdrEPR, String query) throws Exception{
		   StringReader queryReader = new StringReader(query);
		   QueryServiceClient queryService =   new QueryServiceClient(mdrEPR);
			IQuery iquery = QueryInputTransformer.transform(queryReader);
		    return queryService.graphQuery(iquery);
		}
		
	public static void renderStatusResult(PrintWriter output, Element result ) throws Exception {
		//
		// convert result XML to JSON
		//
		String json = "[ ";
		int instanceCount = 0;
				
		Element docRoot = XmlUtils.getDocumentRoot(result);
		NodeList rootNodes = docRoot.getChildNodes();

		
		for (int bi=0; bi<rootNodes.getLength(); bi++) {
			Node node = rootNodes.item(bi);
			if (node.getNodeType() != Node.ELEMENT_NODE)
				continue;
			Element response = (Element)node;
					
					// look for "instanceResponse" or "registerMDREntriesResponseType"...
					if( response.getNodeName().equals("cmdbf:instanceResponse")) {
						NodeList instanceNodes = response.getChildNodes();
		
						for (int j=0; j<instanceNodes.getLength(); j++) {
							Node instanceNode = instanceNodes.item(j);
							if (instanceNode.getNodeType() != Node.ELEMENT_NODE)
								continue;
								Element instanceId = (Element)instanceNode;
								if( instanceId.getNodeName().equals("cmdbf:instanceId")) {
									if(instanceCount> 0)
										json += ",";							
									instanceCount++;
									json += "[";
									NodeList irContentNodes = instanceId.getChildNodes();
									
									String irId = "";
									for(int irCount=0; irCount<irContentNodes.getLength(); irCount++) {
										Node irContentNode = irContentNodes.item(irCount);
										if (irContentNode.getNodeType() != Node.ELEMENT_NODE)
											continue;
										Element irContent = (Element)irContentNode;
										if (irContent.getNodeName().equals("cmdbf:localId")) {
											irId = irContent.getTextContent();
										}
									}
									json += "\"" + irId + "\"";
								}
								else if( instanceId.getNodeName().equals("cmdbf:accepted")) {
									json += ",\"accepted\"";
								}
								else if( instanceId.getNodeName().equals("cmdbf:declined")) {
									json += ",\"declined\"";
								}
								

							}
							json += "]";
							
						}
					}

		json += "]";
		output.print( json );
	}

}
