/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: XMLRepository.java,v 1.2 2008/04/10 22:08:02 sleeloy Exp $
 **********************************************************************/
 package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class XMLRepository {
	public static final String XMLREPOSITORY="org.eclipse.cosmos.dr.drs.service.handler.xml.XMLRepository";
	
	protected Map<Object, String> repository = new HashMap<Object, String>();
	public InputStream getXMLStream(Object id){
		String fragment = repository.get(id);
		if (fragment != null){
			return new ByteArrayInputStream(fragment.getBytes());
		}
		return null;
	}
	
	public InputStream getFirstStream(){
		if (repository.isEmpty())
			return null;
		return new ByteArrayInputStream(repository.values().iterator().next().getBytes());
	}
	public void saveXMLContent(Object id, String xmlFragment){
		System.out.println("SAVGIN : " + id + " " + xmlFragment);
		repository.put(id, xmlFragment);
	}
}
