/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform;


import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.DeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.transform.ITransformerHandler;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * SAX parser that builds IDeregisterRequest object from XML input
 * 
 * @provisional
 * @author David Whiteman
 */
public class DeregistrationInputStreamHandler extends DefaultHandler implements ITransformerHandler 
{
	private IDeregisterRequest request;
	private String currentElementData;
	private IInstanceId currentInstanceId;
//	private boolean inRelationshipIdList = false;
	private boolean inItemIdList = false;
	private IDeregisterInputArtifactFactory artifactFactory;

	
	public DeregistrationInputStreamHandler(
			IDeregisterInputArtifactFactory artifactFactory) {
		this.artifactFactory = artifactFactory;
	}

	public DeregistrationInputStreamHandler() {
	}

	public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException 
	{
		if (!ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE.equals(uri))
		{
			return;
		}

		if (IRegistrationTransformerConstants.DEREGISTER_REQUEST_ELEMENT.equals(localName)) {
			request = getArtifactFactory().createDeregisterRequest();
		} else if (IRegistrationTransformerConstants.ITEM_ID_LIST_ELEMENT.equals(localName)) {
			inItemIdList = true;
		} else if (ICMDBfServicesConstants.INSTANCE_ID_ELEMENT.equals(localName)) {
			currentInstanceId = getArtifactFactory().createInstanceId();
		}

	}

	public void endElement(String uri, String localName, String name) throws SAXException 
	{
		if (!ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE.equals(uri))
		{
			return;
		}
		if (ICMDBfServicesConstants.MDR_ID_ELEMENT.equals(localName)) {
			if (currentInstanceId != null) {
				// This is an mdrId found inside some instanceId element
				currentInstanceId.setMdrId(currentElementData);
			} else {
				// Must be the mdrId for the register request
				request.setMdrId(CMDBfServicesUtil.createURI(currentElementData));
			}
			currentElementData = null;
		} else if (ICMDBfServicesConstants.LOCAL_ID_ELEMENT.equals(localName)) {
			currentInstanceId.setLocalId(currentElementData);
			currentElementData = null;
		} else if (ICMDBfServicesConstants.INSTANCE_ID_ELEMENT.equals(localName)) {
			if (inItemIdList) 
			{
				IItem item = getArtifactFactory().createItem();
				item.addInstanceId(currentInstanceId);
				request.addItem(item);
			} else 
			{
				IRelationship relationship = getArtifactFactory().createRelationship();
				relationship.addInstanceId(currentInstanceId);
				request.addRelationship(relationship);
			}
			currentInstanceId = null;
		} else if (IRegistrationTransformerConstants.ITEM_ID_LIST_ELEMENT.equals(localName)) {
			inItemIdList = false;
		}
				
	}

	public void characters(char[] ch, int start, int length) throws SAXException 
	{
		String tempData = new String(ch, start, length).trim();
		if (currentElementData == null) {
			currentElementData = tempData;
		} else {
			StringWriter tempWriter = new StringWriter();
			tempWriter.write(tempData);
			currentElementData += tempWriter.toString();
		}
	}

	public IDeregisterRequest getRequest() 
	{
		return request;
	}

	public void error(SAXParseException e) throws SAXException 
	{
		throw e;
	}

	public IRootElement getResult() {
		return (IRootElement) getRequest();
	}

	public IDeregisterInputArtifactFactory getArtifactFactory() {
		if (artifactFactory == null) {
			artifactFactory = DeregisterInputArtifactFactory.getInstance();
		}
		return artifactFactory;
	}
}
