/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform;


import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.DeregisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.AbstractOutputStreamHandler;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IRegistrationServiceOutputArtifactFactory;

/**
 * SAX parser that builds DeregisterRequest object from XML input
 * 
 * @provisional
 * @author David Whiteman
 */
public class DeregistrationOutputStreamHandler extends AbstractOutputStreamHandler 
{
	public DeregistrationOutputStreamHandler(
			IRegistrationServiceOutputArtifactFactory artifactFactory) {
		super(artifactFactory);
	}

	protected String getResponseElementName() {
		return IRegistrationTransformerConstants.DEREGISTER_RESPONSE_ELEMENT;
	}

	@Override
	protected IRegistrationServiceOutputArtifactFactory createArtifactFactory() {
		return DeregisterOutputArtifactFactory.getInstance();
	}

}
