/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IItemList;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRelationshipList;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * Interface that must be implemented in order to create
 * POJOs for the deregister request
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IDeregisterInputArtifactFactory {

	/**
	 * Answer a new instance of an {@link IDeregisterRequest}
	 * 
	 * @return
	 */
	public abstract IDeregisterRequest createDeregisterRequest();

	/**
	 * Answer a new instance of an {@link IItemIdList}
	 * 
	 * @return
	 */
	public abstract IItemList createItemList();

	/**
	 * Answer a new instance of an {@link IRelationshipIdList}
	 * 
	 * @return
	 */
	public abstract IRelationshipList createRelationshipList();

	/**
	 * Answer a new instance of IInstanceId with the indicated attributes
	 * 
	 * @param mdrId URI string containing the MDR's ID
	 * @param localId URI string with the local ID of the instance
	 * @return
	 */
	public abstract IInstanceId createInstanceId(String mdrId, String localId);

	/**
	 * Answer a new instance of IInstanceId
	 * 
	 * @return
	 */
	public abstract IInstanceId createInstanceId();

	/**
	 * Answer a new instance of IItem for a deregistration request
	 * 
	 * @return
	 */
	public abstract IItem createItem();

	/**
	 * Answer a new instance of IRelationship for a deregistration request
	 * 
	 * @return
	 */
	public abstract IRelationship createRelationship();

}