/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.internal.deregistration.transform.output.artifacts.DeregisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts.Accepted;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts.AlternateInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts.Declined;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts.InstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IAccepted;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IAlternateInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IDeclined;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Factory for creating artifacts related to deregistration responses
 * 
 * @provisional
 * @author David Whiteman
 */
public class DeregisterOutputArtifactFactory implements IDeregisterOutputArtifactFactory {

	private static IDeregisterOutputArtifactFactory instance;

	public static IDeregisterOutputArtifactFactory getInstance() {
		if (instance == null) {
			instance = new DeregisterOutputArtifactFactory();
		}

		return instance;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory#createInstanceResponse()
	 */
	public IInstanceResponse createInstanceResponse() {
		return new InstanceResponse();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory#createDeclined()
	 */
	public IDeclined createDeclined() {
		return new Declined();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory#createAccepted()
	 */
	public IAccepted createAccepted() {
		return new Accepted();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory#createAlternateInstanceId(java.lang.String, java.lang.String)
	 */
	public IAlternateInstanceId createAlternateInstanceId(String mdrId,
			String localId) {
		return new AlternateInstanceId(mdrId, localId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory#createAlternateInstanceId()
	 */
	public IAlternateInstanceId createAlternateInstanceId() {
		return new AlternateInstanceId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory#createInstanceId(java.lang.String, java.lang.String)
	 */
	public IInstanceId createInstanceId(String mdrId, String localId) {
		return CommonArtifactFactory.getInstance().createInstanceId(mdrId, localId);
	}

	public IInstanceId createInstanceId() {
		return CommonArtifactFactory.getInstance().createInstanceId();
	}

	public IResponse createResponse() {
		return new DeregisterResponse();
	}

}
