/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts;

import java.io.StringWriter;
import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IItemList;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRelationshipList;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRequest;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

public abstract class AbstractRequest implements IRequest
{
	private URI mdrId;
	private IItemList itemList;
	private IRelationshipList relationshipList;

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX+getRequestElement() +" xmlns:" + ICMDBfServicesConstants.CMDBF_PREFIX_RAW + "=\""+ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE+ICMDBfServicesConstants.DOUBLE_QUOTE+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.addIndent(writer, indent+1);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.MDR_ID_ELEMENT));
		writer.write(getMdrId().toString());
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.MDR_ID_ELEMENT)+ICMDBfServicesConstants.nl);

		if (itemList != null) {
			((IXMLWritable) itemList).toXML(writer, indent+1);
		} 
		if (relationshipList != null) {
			((IXMLWritable) relationshipList).toXML(writer, indent+1);
		}
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + getRequestElement())+ICMDBfServicesConstants.nl);
	}

	protected abstract String getRequestElement();
	
	protected abstract boolean isIdList();
	

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest#getMdrId()
	 */
	public URI getMdrId() {
		return mdrId;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest#setMdrId(java.net.URI)
	 */
	public void setMdrId(URI mdrId) {
		this.mdrId = mdrId;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest#addItem(org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.Item)
	 */
	public void addItem(IItem item) {
		getItemListInit().addItem(item);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest#getItemList()
	 */
	public IItemList getItemList() {
		return itemList;
	}

	private IItemList getItemListInit() {
		initItemList();
		return itemList;
	}

	private void initItemList() {
		if (itemList == null) {
			itemList = RegisterInputArtifactFactory.getInstance().createItemList(isIdList());
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest#addRelationship(org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.Relationship)
	 */
	public void addRelationship(IRelationship relationship) {
		getRelationshipListInit().addRelationship(relationship);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterRequest#getRelationshipList()
	 */
	public IRelationshipList getRelationshipList() {
		return relationshipList;
	}
	
	private IRelationshipList getRelationshipListInit() {
		initRegisterRequest();
		return relationshipList;
	}

	private void initRegisterRequest() {
		if (relationshipList == null) {
			relationshipList = RegisterInputArtifactFactory.getInstance().createRelationshipList(isIdList());
		}
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result +
				((itemList == null) ? 0 : itemList.hashCode());
		result = prime * result + ((mdrId == null) ? 0 : mdrId.hashCode());
		result = prime * result +
				((relationshipList == null) ? 0 : relationshipList.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AbstractRequest other = (AbstractRequest) obj;
		if (itemList == null) {
			if (other.itemList != null)
				return false;
		} else if (!itemList.equals(other.itemList))
			return false;
		if (mdrId == null) {
			if (other.mdrId != null)
				return false;
		} else if (!mdrId.equals(other.mdrId))
			return false;
		if (relationshipList == null) {
			if (other.relationshipList != null)
				return false;
		} else if (!relationshipList.equals(other.relationshipList))
			return false;
		return true;
	}


}
