/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts;

import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IItemList;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;

public class ItemList extends GraphElementCollection implements IItemList 
{	
	public ItemList(boolean itemListId, List<IGraphElement> elements) 
	{
		super(itemListId, elements);				
	}

	public ItemList(boolean itemListId) 
	{
		super(itemListId);
	}

	public void addItem(IItem item) 
	{
		getCollection().add(item);
	}

	protected String getElementName(boolean idList) 
	{
		return 	idList ? 
				IRegistrationTransformerConstants.ITEM_ID_LIST_ELEMENT :
				IRegistrationTransformerConstants.ITEM_LIST_ELEMENT;
	}
}
