/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IAccepted;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

public class Accepted implements IAccepted {
	
	List<IInstanceId> alternateInstanceIds;

	public Accepted() {
		super();
		alternateInstanceIds = new ArrayList<IInstanceId>();
	}

	public void addAlternateInstanceId(IInstanceId instanceId) {
		alternateInstanceIds.add(instanceId);
	}

	public IInstanceId[] getAlternateInstanceIds() {
		return (IInstanceId[])alternateInstanceIds.toArray(new IInstanceId[alternateInstanceIds.size()]);
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.ACCEPTED_ELEMENT)+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, alternateInstanceIds);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.ACCEPTED_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((alternateInstanceIds == null) ? 0 : alternateInstanceIds
						.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Accepted other = (Accepted) obj;
		if (alternateInstanceIds == null) {
			if (other.alternateInstanceIds != null)
				return false;
		} else if (!alternateInstanceIds.equals(other.alternateInstanceIds))
			return false;
		return true;
	}

}
