/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IDeclined;

public class Declined implements IDeclined {
	
	List<String> reasons;

	public Declined() {
		super();
		this.reasons = new ArrayList<String>();
	}

	public void addReason(String reason) {
		this.reasons.add(reason);
	}

	public String[] getReasons() {
		return (String[])reasons.toArray(new String[reasons.size()]);
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.DECLINED_ELEMENT)+ICMDBfServicesConstants.nl);
		
		for (Iterator<String> iterator = reasons.iterator(); iterator.hasNext();) {
			String reason = (String) iterator.next();
			CMDBfServicesUtil.addIndent(writer, indent+1);
			writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.REASON_ELEMENT));
			writer.write(reason);
			writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.REASON_ELEMENT)+ICMDBfServicesConstants.nl);
		}
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.DECLINED_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((reasons == null) ? 0 : reasons.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Declined other = (Declined) obj;
		if (reasons == null) {
			if (other.reasons != null)
				return false;
		} else if (!reasons.equals(other.reasons))
			return false;
		return true;
	}

}
