/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.output.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.IRegistrationTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IAccepted;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IDeclined;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

public class InstanceResponse implements IInstanceResponse {
	
	IAccepted accepted;
	IDeclined declined;
	IInstanceId instanceId;

	public IAccepted getAccepted() {
		return accepted;
	}

	public IDeclined getDeclined() {
		return declined;
	}

	public IInstanceId getInstanceId() {
		return instanceId;
	}

	public void setAccepted(IAccepted accepted) {
		this.accepted = accepted;
		if (accepted != null) {
			setDeclined(null);
		}
	}

	public void setDeclined(IDeclined declined) {
		this.declined = declined;
		if (declined != null) {
			setAccepted(null);
		}
	}

	public void setInstanceId(IInstanceId instanceId) {
		this.instanceId = instanceId;
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.INSTANCE_RESPONSE_ELEMENT)+ICMDBfServicesConstants.nl);
		
		instanceId.toXML(writer, indent+1);
		if (accepted != null) {
			accepted.toXML(writer, indent+1);
		} else if (declined != null) {
			declined.toXML(writer, indent+1);
		}
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IRegistrationTransformerConstants.INSTANCE_RESPONSE_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((accepted == null) ? 0 : accepted.hashCode());
		result = prime * result
				+ ((declined == null) ? 0 : declined.hashCode());
		result = prime * result
				+ ((instanceId == null) ? 0 : instanceId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final InstanceResponse other = (InstanceResponse) obj;
		if (accepted == null) {
			if (other.accepted != null)
				return false;
		} else if (!accepted.equals(other.accepted))
			return false;
		if (declined == null) {
			if (other.declined != null)
				return false;
		} else if (!declined.equals(other.declined))
			return false;
		if (instanceId == null) {
			if (other.instanceId != null)
				return false;
		} else if (!instanceId.equals(other.instanceId))
			return false;
		return true;
	}

}
