/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;

/**
 * Represents an <itemList> in a registration request element tree
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IItemList extends IGraphElementCollection {
	/**
	 * Add an IItem to the item list
	 * 
	 * @param item
	 */
	public void addItem(IItem item);
}
