/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * General parent type of IRegisterRequest and IDeregisterRequest
 * objects
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IRequest extends IXMLWritable, IRootElement
{
	/**
	 * Set the ID of the MDR for which the request is intended
	 * 
	 * @param mdrId
	 */
	public void setMdrId(URI mdrId);

	/**
	 * Answer the ID of the MDR for which the request is intended
	 * 
	 * @return
	 */
	public URI getMdrId();

	/**
	 * Add an {@link IItem} to the item list for the receiver
	 * 
	 * @param item
	 */
	public void addItem(IItem item);

	/**
	 * Answer the item list for the receiver
	 * 
	 * @return
	 */
	public IItemList getItemList();

	/**
	 * Add an {@link IRelationship} to the relationship list for the receiver
	 * 
	 * @param relationship
	 */
	public void addRelationship(IRelationship relationship);
	
	
	/**
	 * Answer the relationship list for the receiver
	 * 
	 * @return
	 */
	public IRelationshipList getRelationshipList();
}
