/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts.Item;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts.ItemList;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts.RegisterRequest;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts.Relationship;
import org.eclipse.cosmos.dc.cmdbf.services.internal.registration.transform.input.artifacts.RelationshipList;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * Create artifacts needed to create POJO representations of the
 * <registerRequest> XML structure from the CMBDf registration service.
 * Adopters can replace this default implementation of the factory by
 * implementing {@link IRegisterInputArtifactFactory} and supplying
 * the object to the registration operation.
 * 
 * @provisional
 * @author David Whiteman
 */
public class RegisterInputArtifactFactory implements IRegisterInputArtifactFactory {

	private static IRegisterInputArtifactFactory instance;

	public static IRegisterInputArtifactFactory getInstance() {
		if (instance == null) {
			instance = new RegisterInputArtifactFactory();
		}

		return instance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createItem()
	 */
	public IItem createItem() {
		return new Item();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createRelationship()
	 */
	public IRelationship createRelationship() {
		return new Relationship();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createRelationshipList(boolean)
	 */
	public IRelationshipList createRelationshipList(boolean idList) {
		return new RelationshipList(idList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createItemList(boolean)
	 */
	public IItemList createItemList(boolean idList) {
		return new ItemList(idList);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createRegisterRequest()
	 */
	public IRegisterRequest createRegisterRequest() {
		return new RegisterRequest();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createInstanceId(java.lang.String,
	 *      java.lang.String)
	 */
	public IInstanceId createInstanceId(String mdrId, String localId) {
		return CommonArtifactFactory.getInstance().createInstanceId(mdrId, localId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createRecord(org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement,
	 *      java.lang.String)
	 */
	public IRecord createRecord(IGraphElement parent, String recordId) {
		return CommonArtifactFactory.getInstance().createRecord(parent, recordId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createRecordMetadata()
	 */
	public IRecordMetadata createRecordMetadata() {
		return CommonArtifactFactory.getInstance().createRecordMetadata();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRegisterInputArtifactFactory#createAdditionalRecordType(java.lang.String,
	 *      java.lang.String)
	 */
	public IAdditionalRecordType createAdditionalRecordType(String namespace,
			String localName) {
		return CommonArtifactFactory.getInstance().createAdditionalRecordType(
				namespace, localName);
	}

	public IInstanceId createInstanceId() {
		return CommonArtifactFactory.getInstance().createInstanceId();
	}
}
