/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * Parent interface of IRegisterOutputArtifactFactory and IDeregisterOutputArtifactFactory.
 * Both registration and deregistration responses have the same structure, so this is
 * shared here.  We still provide the subinterfaces for clarity.
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IRegistrationServiceOutputArtifactFactory {

	/**
	 * Answer a new instance of either IRegisterResponse or
	 * IDeregisterResponse.
	 * 
	 * @return
	 */
	public abstract IResponse createResponse();
	
	/**
	 * Answer a new instance of IAccepted that indicates the
	 * request was accepted
	 * 
	 * @return
	 */
	public abstract IAccepted createAccepted();

	/**
	 * Answer a new instance of {@link IAlternateInstanceId}.  Users of this API
	 * are expected to set the mdrId and localId before using
	 * the new object.
	 * 
	 * @return
	 */
	public abstract IAlternateInstanceId createAlternateInstanceId();

	/**
	 * Answer a new instance of {@link IAlternateInstanceId}, initialized with the given
	 * mdrId and localId
	 * 
	 * @param mdrId
	 * @param localId
	 * @return
	 */
	public abstract IAlternateInstanceId createAlternateInstanceId(
			String mdrId, String localId);

	/**
	 * Answer a new instance of IDeclined that indicates the
	 * request was declined
	 * 
	 * @return
	 */
	public abstract IDeclined createDeclined();

	/**
	 * Answer a new instance of IInstanceId with the indicated attributes
	 * 
	 * @param mdrId URI string containing the MDR's ID
	 * @param localId URI string with the local ID of the instance
	 * @return
	 */
	public abstract IInstanceId createInstanceId(String mdrId, String localId);

	/**
	 * Answer a new instance of {@link IInstanceResponse}
	 * 
	 * @return
	 */
	public abstract IInstanceResponse createInstanceResponse();

	public abstract IInstanceId createInstanceId();

}
