/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents register responses and deregister responses as part of the
 * CMDBf registration service.
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IResponse extends IXMLWritable, IRootElement {
	/**
	 * Add an {@link IInstanceResponse} to the receiver
	 * 
	 * @param instanceResponse
	 */
	public abstract void addInstanceResponse(IInstanceResponse instanceResponse);

	/**
	 * Answer an array of all {@link IInstanceResponse} instances previously
	 * added to the receiver
	 * 
	 * @return
	 */
	public abstract IInstanceResponse[] getInstanceResponses();

}
