/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.dataManager.api;

import java.util.Properties;

import javax.xml.namespace.QName;

import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;

@ManagedResourceCapability(namespace=IDataManager.NAMESPACE_URI)
public interface IDataManager {
	
	// Configuration key names
//	public static final String CONFIG_MGMT_DOMAIN_URI = "MGMT_DOMAIN_URI";
//	public static final String CONFIG_MGMT_DOMAIN_RESOURCEID = "MGMT_DOMAIN_RESOURCEID";
//	public static final String CONFIG_DATA_MANAGER_URI = "ENDPOINTADDRESS";
//	public static final String CONFIG_DATA_MANAGER_RESOURCE_ID = "ENDPOINTRESOURCEID";
//	public static final String CONFIG_CLASSIFICATION = "CLASSIFICATION";
//	public static final String CONFIG_DIALECT = "DIALECT";

	/**
	 * Resource ID of data manager.  The ID is a unique identifier of the data manager. 
	 */
	public static final String CONFIG_DATA_MANAGER_RESOURCE_ID = "RESOURCE_ID";
	
	/**
	 * The display name of the data manager.  
	 */
	public static final String CONFIG_DATA_MANAGER_DISPLAY_NAME = "DISPLAY_NAME";
	
	/**
	 * Description of the data manager. 
	 */
	public static final String CONFIG_DATA_MANAGER_DESCRIPTION = "DESCRIPTION";
	
	/**
	 * Path to a file that contains the EPR of the management domain.
	 * The path is relative to root of the data manager OSGi bundle.  
	 */
	public static final String CONFIG_MGMT_DOMAIN_EPR_FILE = "MGMT_DOMAIN_EPR_FILE";
	

	public static final String NAMESPACE_URI = "http://www.eclipse.org/cosmos/dataManager";
	
	public String PREFIX = "dm";
	
	public String REGISTER_OP_URI = NAMESPACE_URI + "/register";
	public QName REGISTER_OP_QNAME = new QName(NAMESPACE_URI, "register", PREFIX);
	
	String DEREGISTER_OP_URI = NAMESPACE_URI + "/deregister";
	QName DEREGISTER_OP_QNAME = new QName(NAMESPACE_URI, "deregister", PREFIX);
	
	/**
	 * Register data manager with COSMOS broker
	 * @throws DataManagerException
	 */
	@ManagedOperation
	public void register() throws DataManagerException;
	
	/**
	 * Deregister data manager with COSMOS broker.  
	 * @throws DataManagerException
	 */
	@ManagedOperation
	public void deregister() throws DataManagerException;
	
	/**
	 * Provide a set of configuration name-value pairs in the form of a Properties object.
	 * These values are specific to the instance of the data manager and are used during
	 * initialization and can be accessed by the data manager implementation.  
	 * 
	 * @param config Configuration values
	 */
	public void setConfigProperties(Properties config);

	/**
	 * Set management domain EPR.
	 * @param domainEPR
	 */
	public void setManagementDomainEPR(EndpointReference domainEPR);
}
