/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.common;

import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;

/**
 * An abstract implementation of an item notification handler
 * that simplifies the process of object creations.  A subclass will
 * only need to implement a handler method that will return null 
 * if the item is accepted OR a message in the form of a {@link String} 
 * if the item is declined.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public abstract class AbstractItemNotificationHandler extends AbstractNotificationHandler implements IItemNotificationHandler
{	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.IItemNotificationHandler#handle(int, org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IItem)
	 */
	public IInstanceResponse handle(int type, IItem item)
	{
		String response = handleItem(type,item);	
		setIds(item);			
		return response == null ? createAcceptResponse() : createDeclinedResponse(response);
	}

	
	/**
	 * Handle the item passed in.  A return value of null will
	 * indicate the acceptance of the item; otherwise the returned 
	 * value is a reason for declining the item.
	 * 
	 * @param type The type of request
	 * @param item The item to be handled
	 * @return null or a message indicating the reason for a decline
	 */
	public abstract String handleItem (int type, IItem item);
}
