/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.common;

import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * An abstract relationship notification handler used for handler
 * relationship registration/deregistration.  Clients can either extend this
 * class or provide a direct implementation of the required interface.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public abstract class AbstractRelationshipNotificationHandler extends AbstractNotificationHandler implements IRelationshipNotificationHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.IRelationshipNotificationHandler#handle(int, org.eclipse.cosmos.dc.cmdbf.services.registration.transform.input.artifacts.IRelationship)
	 */
	public IInstanceResponse handle(int type, IRelationship relationship)
	{
		String response = handleRelationship(type, relationship);	
		setIds(relationship);
		return response == null ? createAcceptResponse() : createDeclinedResponse(response);
	}
	
	
	/**
	 * Handle the relationship passed in.  A return value of null will
	 * indicate the acceptance of the relationship; otherwise the returned 
	 * value is a reason for declining the relationship.
	 * 
	 * @param type The type of request
	 * @param relationship The relationship to be handled
	 * @return null or a message indicating the reason for a decline
	 */
	public abstract String handleRelationship (int type, IRelationship relationship);

}
