/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.impl;

import java.io.InputStream;
import java.io.Reader;

import org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.ICMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.DeregistrationInputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.DeregisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterResponse;
import org.eclipse.cosmos.dc.cmdbf.services.registration.transform.output.artifacts.IRegistrationServiceOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.TransformerException;

/**
 * This is the default implementation of {@link ICMDBfDeregistrationOperation}.  Contributors
 * can choose to use this default implementation or provide a direct implementation
 * of {@link ICMDBfDeregistrationOperation}.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public class CMDBfDeregistrationOperation extends AbstractNotificationOperation implements ICMDBfDeregistrationOperation
{
	/**
	 * Constructor
	 * 
	 * @param factory The factory class associated with this operation
	 */
	public CMDBfDeregistrationOperation(INotificationHandlerFactory factory, IDeregisterOutputArtifactFactory outputArtifactFactory)
	{
		super(factory, outputArtifactFactory);
	}

	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.deregistration.service.ICMDBfDeregistrationOperation#execute(java.io.Reader)
	 */
	public IDeregisterResponse execute(Reader registration) throws CMDBfServiceException
	{
		return execute((Object)registration);
	}
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.registration.service.ICMDBfRegistrationOperation#execute(java.io.InputStream)
	 */
	public IDeregisterResponse execute(InputStream registration) throws CMDBfServiceException
	{		
		return execute((Object)registration);
	}
	

	private IDeregisterResponse execute(Object registration) throws CMDBfServiceException
	{		
		try
		{
			IDeregisterResponse response = (IDeregisterResponse) getOutputArtifactFactory().createResponse();
			super.execute (registration instanceof Reader ? DeregistrationInputTransformer.transform((Reader)registration) : DeregistrationInputTransformer.transform((InputStream)registration), response, INotificationHandler.DEREGISTRATION);
			return response;
		}
		catch (TransformerException te)
		{
			throw new IllegalArgumentException(te);
		}
	}

	@Override
	protected IRegistrationServiceOutputArtifactFactory createArtifactFactory() {
		return DeregisterOutputArtifactFactory.getInstance();
	}
}
