/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.logging.datamgr.ws.client.CBEClient;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;

public class CBEDataSourceOutputter extends AbstractOutputter {

	public void render(PrintWriter output, IParameters input) throws Exception {

		String title = input.getParameter("title");
		String prop = input.getParameter("prop");
		String eprparm = input.getParameter("epr");

		Collection<CommonBaseEvent> cbe_coll = null;
		CBEClient dmc = new CBEClient (eprparm);

		if (dmc == null){
			System.out.println("Error unable to create CBE Data Manager");
			return;
		}

		if ( prop != null && prop.equalsIgnoreCase("true")){
 			try {
 				cbe_coll = dmc.getAllCBE(title);
 			} catch (CosmosException ex) {
				System.out.println("Error getting CBE information for " + title);
				ex.printStackTrace();
			}
			
			if (cbe_coll != null) {
				Iterator<CommonBaseEvent> I_cbe = cbe_coll.iterator();
				output.print("[");
				while (I_cbe.hasNext()){
					CommonBaseEvent cbe = I_cbe.next(); 

					output.print("	[ \"Name\", '" + title + "'],");
					output.print("	[ \"Creation Time\", '" + cbe.getCreationTime().replace('T', ' ') + "'],");
					output.print("	[ \"Extension Name\", '" + cbe.getExtensionName() + "'],");
					//output.print("	[ \"Msg\", '" + cbe.getMsg() + "'],");
					output.print("	[ \"SubComponent\", '" + cbe.getSourceComponentId().getSubComponent() + "'],");
					output.print("	[ \"Location\", '" + cbe.getSourceComponentId().getLocation() + "']");
				}
				output.print("]");			
			} else {
				System.out.println("Error no CBE collection for " + title);
			}
		} else {
			// get the data sources from the CBE Data Manager client
			Collection<String> dsn_coll = null;
			
			try {
				dsn_coll = dmc.getDatasets();
			} catch(CosmosException ex) {
				System.out.println("Error retrieving datasets");
				ex.printStackTrace();
			}

			if (dsn_coll != null) {
				Iterator<String> I_dsn = null;
				String dsn = null;
				
				output.print("{ identifier: \"object\",  label: \"title\",  items:[" );
				I_dsn = dsn_coll.iterator();
				while (I_dsn.hasNext()){
					dsn = I_dsn.next();
					output.print("{nodeClass:\"datasource\", title:\"" 
							+ dsn 
							+ "\", logfile:\"" 
							+ dsn 
							+ "\", epr:\'" + eprparm 
							+ "\', classification:\"CBE\"");
					//TODO: add more properties on the datasource
					output.print(", store:[");
					output.print("['epr', '"+eprparm+"']");
					output.print(",['logfile', '"+dsn+"']");
					output.print("]}");
			
					if(I_dsn.hasNext()) output.print(",");
				}
				output.print("]}");
			}	
		}
		
	}
}
