/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Date;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.eclipse.cosmos.common.exceptions.CosmosException;
import org.eclipse.cosmos.dc.stat.datamgr.ws.client.StatisticalDataManagerClient;
import org.eclipse.cosmos.dc.stat.datamgr.ws.client.StatisticalTuple;
import org.eclipse.cosmos.dc.stat.datamgr.ws.client.StatisticalObservation;
import org.eclipse.cosmos.dc.stat.datamgr.ws.common.DataSourceKeyset;

public class StatDataSourceOutputter extends AbstractOutputter {

	public void render(PrintWriter output, IParameters input) throws Exception {
		String title = input.getParameter("title");
		String prop = input.getParameter("prop");
		String eprparm = input.getParameter("epr");
		
		StatisticalDataManagerClient dmc = new StatisticalDataManagerClient (eprparm);
		
		if ( prop != null && prop.equalsIgnoreCase("true")){
			boolean err = false;
			Collection<StatisticalTuple> st_coll = null;
 			try {
 				st_coll = dmc.getStatDataForSource(title,"TomcatSet",0,1000);
 			} catch (CosmosException ex) {
 				err = true;
 				System.out.println("Couldn't get StatData");
				ex.printStackTrace();
			}
 			if (!err) {
 				if (st_coll != null) {
 					Iterator I_st = st_coll.iterator();
 					
 					output.print("[");
 					
 					while (I_st.hasNext()) {
 						StatisticalTuple st = (StatisticalTuple) I_st.next();
 						StatisticalObservation so_arr[] = st.getObservations();
 						Date st_date = st.getTimeStamp();
 						
 						output.print("	[ \"Date\", '" + st_date + "'],");
 						int so_count = 0;
 						for(StatisticalObservation so: so_arr){
 							output.print("	[ \"Name\", '" + so.getName() + "'],");
 							if (so.isContinuousObservation())
 								output.print("	[ \"Value\", '" + so.getContinuousValue() + "']");
 							else if (so.isIntegralObservation())
 								output.print("	[ \"Value\", '" + so.getIntegralValue() + "']");
 							else
 								output.print("	[ \"Value\", '" + so.getStringValue() + "']");
 							
 							if((so_count++ < so_arr.length) )
 								output.print(",");
 						}

 						if(I_st.hasNext())
 							output.print(",");
 						
 						System.out.println(st.toString());
 					}

 					output.print("]");
 				}
 				else
 					System.out.println("null collection");
 			}
		} else {
			// get the data source keysets from the CBE Data Manager client
			Collection<DataSourceKeyset> dsk_coll = null;
			
			try {
				if (dmc != null) dsk_coll = dmc.getDatasourceKeyset();
			} catch(CosmosException ex) {
				System.out.println("Error retrieving data source keysets");
				ex.printStackTrace();
			}
			if (dsk_coll != null) {
				Iterator<DataSourceKeyset> I_dsk = null;
				
				output.print("{ identifier: \"object\",  label: \"title\",  items:[" );
				I_dsk = dsk_coll.iterator();
				while (I_dsk.hasNext()){
					DataSourceKeyset dsk = I_dsk.next();
					output.print("{nodeClass:\"statdatasource\", title:\"" 
							+ dsk.getDataSet() 
							+ "\", datasource:\"" 
							+ dsk.getDataSet() 							
							+ "\", keyset:\""
						    + dsk.getKeySet()
							+ "\", epr:\'" + eprparm 
							+ "\', classification:\"TomcatSet\"");
					//TODO: add more properties on the datasource
					output.print(", store:[");
					output.print("['epr', '"+eprparm+"']");
					output.print(",['datasource', '"+dsk.getDataSet()+"']");
					output.print(",['keyset', '"+dsk.getKeySet()+"']");
					output.print("]}");
					

					if(I_dsk.hasNext()) output.print(",");
				}
				output.print("]}");
			}	
		}
	}
}
