/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ServiceContext;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Groups;
import org.eclipse.cosmos.dc.broker.ws.persistence.BrokerDatabase;
import org.eclipse.cosmos.dc.broker.ws.persistence.internal.BrokerDatabaseImpl;

/**
 * A broker is an address registry that store the service EPRs of web services 
 * and information about the services.  
 *
 */
public class Broker {
	
	BrokerDatabase database = null;
	
	public void init(ServiceContext serviceContext) {
		database = BrokerDatabaseImpl.getInstance();

		File dbdir = serviceContext.getConfigurationContext().getRealPath("database");
//		System.out.println(dbdir.getAbsolutePath());

		Map<String, Object> initMap = new HashMap<String, Object>();
		initMap.put("dbdir", dbdir);
		database.init(initMap);
	}
	
	/**
	 * Register a group of web services with the broker.
	 * 
	 * @param group
	 * @return
	 */
	public OMElement registerGroup(OMElement registerGroupRequest) {
		System.out.println("In registerGroup");
		System.out.println(registerGroupRequest.toString());
		OMElement groupElem = registerGroupRequest.getFirstElement();
		database.addGroup(Group.getGroup(groupElem));
		// TODO: what to return?
		return null;
	}
	
	/**
	 * Deregister a group of web services from the broker.
	 * @param groupId
	 * @return
	 */
	public OMElement deregisterGroup(OMElement deregisterRequest) {
		System.out.println("In deregisterGroup");
		
		String host = null;
		String groupName = null;
		
		Iterator<?> childIter = deregisterRequest.getChildElements();
		while (childIter.hasNext()) {
			OMElement elem = (OMElement) childIter.next();
			if (elem.getLocalName().equals("host")) {
				host = elem.getText();
			} else if (elem.getLocalName().equals("name")) {
				groupName = elem.getText();
			}
		}
		
		if (host != null && groupName != null) {
			database.deleteGroup(host, groupName);
		} else {
			// TODO: throw exception: Malformed deregister group request
		}
		// TODO: what to return?
		return null;
	}
	
	/**
	 * Gets all groups of web services registered at the broker
	 * @return
	 */
	public OMElement getAllGroups(OMElement getAllGroupsRequest) {
		System.out.println("In getAllGroups");
		Groups groups = database.getAllGroups();
		return groups.toOM();
	}
	
	public OMElement getGroup(OMElement getGroupRequest) {
		Group group = new Group();
		String host = null;
		String groupName = null;
		
		Iterator<?> childIter = getGroupRequest.getChildElements();
		while (childIter.hasNext()) {
			OMElement elem = (OMElement) childIter.next();
			if (elem.getLocalName().equals("host")) {
				host = elem.getText();
			} else if (elem.getLocalName().equals("name")) {
				groupName = elem.getText();
			}
		}
		
		if (host != null && groupName != null) {
			group = database.getGroup(host, groupName);
		} else {
			// TODO: throw exception: Malformed deregister group request
			return null;
		}
		
		return group == null ? null : group.toOM();
	}
	
	public OMElement getGroupsByNamespace(OMElement getGroupsByNamespaceRequest) {
		String ns = null;
		Groups groups = new Groups();
		
		Iterator<?> childIter = getGroupsByNamespaceRequest.getChildElements();
		while (childIter.hasNext()) {
			OMElement elem = (OMElement) childIter.next();
			if (elem.getLocalName().equals("namespace")) {
				ns = elem.getText();
			}
		}
		if (ns != null) {
			groups = database.getGroupsByNamespace(ns);
		} else {
			// TODO: throw exception: Malformed getGroupsByEPR request
		}
		return groups.toOM();
	}
}
