/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws.datamodel;

import java.util.Iterator;
import java.util.List;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

/**
 * An object that describes a group of web services.
 *
 */
public class Group {
	private String host;
	private String name;
	private String description;
	private Services services;
	
	/**
	 * @return the id
	 */
	public String getHost() {
		return host;
	}
	
	/**
	 * @param id the id to set
	 */
	public void setHost(String host) {
		this.host = host;
	}
	
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * @return the services
	 */
	public Services getServices() {
		return services;
	}
	
	/**
	 * @param services the services to set
	 */
	public void setServices(Services services) {
		this.services = services;
	}
	
	public OMElement toOM() {
        String id = getHost();
    	String desc = getDescription();
    	String name = getName();
    	
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        
    	OMElement groupxml = fac.createOMElement("group", omNs);
    	OMElement idxml = fac.createOMElement("host", omNs, groupxml);
    	OMElement descxml = fac.createOMElement("description", omNs, groupxml);
    	OMElement namexml = fac.createOMElement("name", omNs, groupxml);
    	
    	fac.createOMText(idxml, id);
    	fac.createOMText(descxml, desc);
    	fac.createOMText(namexml, name);
    	
    	if (getServices() != null) {
    		groupxml.addChild(getServices().toOM());
    	}

    	return groupxml;
	}
	
	public static Group getGroup(OMElement groupxml) {
		Group group = new Group();

		Iterator groupIter = groupxml.getChildElements();
		while (groupIter.hasNext()) {
			OMElement elem = (OMElement) groupIter.next();
			
			if (elem.getLocalName().equals("host")) {
				group.setHost(elem.getText());
			} else if (elem.getLocalName().equals("name")) {
				group.setName(elem.getText());
			} else if (elem.getLocalName().equals("description")) {
				group.setDescription(elem.getText());
			} else if (elem.getLocalName().equals("services")) {
				group.setServices(Services.getServices(elem));
			}
		}
		return group;
	}
}
