/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws.datamodel;

import java.util.Iterator;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

/**
 * An object that describes a web service.
 * 
 */
public class Service {
	private String namespace;
	private String endpointReference;
	private String name;
	private String description;
	/**
	 * Gets the namespace that identifies the web service. 
	 * Namespace can be taken from the WSDL of the service. 
	 * 
	 * @return the namespace 
	 */
	public String getNamespace() {
		return namespace;
	}
	
	/**
	 * Sets the namespace that identifies the web service. 
	 * Namespace can be taken from the WSDL of the service. 
	 * 
	 * @param namespace the namespace to set
	 */
	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}
	
	/**
	 * Gets the service endpoint reference.
	 * 
	 * @return the endpointReference
	 */
	public String getEndpointReference() {
		return endpointReference;
	}
	
	/**
	 * Sets the service endpoint reference. 
	 * 
	 * @param endpointReference the endpointReference to set
	 */
	public void setEndpointReference(String endpointReference) {
		this.endpointReference = endpointReference;
	}
	
	/**
	 * Gets the name of the web service.  
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * Sets the name of the web service
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * Gets the description of the web service
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * Sets the description of the web service
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	public OMElement toOM() {
        String desc = getDescription();
		String name = getName();
		String namespace = getNamespace();
		String endpoint = getEndpointReference();
		
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");

		OMElement servicexml = fac.createOMElement("service", omNs);
    	OMElement namexml2 = fac.createOMElement("name", omNs, servicexml);
    	OMElement descxml2 = fac.createOMElement("description", omNs, servicexml);
		OMElement namespacexml = fac.createOMElement("namespace", omNs, servicexml);
		OMElement endpointxml = fac.createOMElement("endpoint", omNs, servicexml);
		
		fac.createOMText(namexml2, name);
		fac.createOMText(descxml2, desc);
		fac.createOMText(namespacexml, namespace);
		fac.createOMText(endpointxml, endpoint);

		return servicexml;
	}
	
	public static Service getService(OMElement servicexml) {
		Service service = new Service();
		
		Iterator serviceIter = servicexml.getChildElements();
		while (serviceIter.hasNext()) {
			OMElement elem = (OMElement) serviceIter.next();
			if (elem.getLocalName().equals("namespace")) {
				service.setNamespace(elem.getText());
			} else if (elem.getLocalName().equals("name")) {
				service.setName(elem.getText());
			} else if (elem.getLocalName().equals("endpoint")) {
				service.setEndpointReference(elem.getText());
			} else if (elem.getLocalName().equals("description")) {
				service.setDescription(elem.getText());
			}
		}
		return service;
	}
}
