/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IPropertyValue;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRecordConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRecordType;

public class RecordConstraint implements IRecordConstraint {

	private List<IRecordType> recordTypes = new ArrayList<IRecordType>(); // 0 or more
	private List<IPropertyValue> propertyValues = new ArrayList<IPropertyValue>(); // 0 or more

	public void addPropertyValue(IPropertyValue propertyValue) {
		propertyValues.add(propertyValue);
	}

	public void addRecordType(IRecordType recordType) {
		recordTypes.add(recordType);
	}

	public IPropertyValue[] getPropertyValues() {
		return propertyValues.toArray(new IPropertyValue[propertyValues.size()]);
	}

	public IRecordType[] getRecordTypes() {
		return recordTypes.toArray(new IRecordType[recordTypes.size()]);
	}

	public int getType() {
		return IConstraint.RECORD_CONSTRAINT;
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.RECORD_CONSTRAINT_ELEMENT)+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, recordTypes);
		CMDBfServicesUtil.outputListToXML(writer, indent+1, propertyValues);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.RECORD_CONSTRAINT_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((propertyValues == null) ? 0 : propertyValues.hashCode());
		result = prime * result
				+ ((recordTypes == null) ? 0 : recordTypes.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RecordConstraint other = (RecordConstraint) obj;
		if (propertyValues == null) {
			if (other.propertyValues != null)
				return false;
		} else if (!propertyValues.equals(other.propertyValues))
			return false;
		if (recordTypes == null) {
			if (other.recordTypes != null)
				return false;
		} else if (!recordTypes.equals(other.recordTypes))
			return false;
		return true;
	}

}
