/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts;

import java.io.StringWriter;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.IQueryTransformerConstants;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryServiceElementCollection;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;

/**
 * This is an aggregate of Item instances that share
 * a common role, specified by the templateId
 * 
 * @author David Whiteman
 * @author Ali Mehregani
 */
public class Nodes extends GraphElementCollection implements INodes
{
	public Nodes(String itemTemplateId)
	{
		super(itemTemplateId);
	}
	
	public Nodes(IItemTemplate itemTemplate) 
	{
		super(itemTemplate);		 
	}
	
	public Nodes(IItemTemplate itemTemplate, IItemConvertible itemConvertible) 
	{
		super(itemTemplate);
		addItem(itemConvertible.toItem(this));
	}

	@SuppressWarnings("unchecked")
	public Nodes(IItemTemplate itemTemplate, List elements) 
	{
		super(itemTemplate, elements);
	}
	
	public void addItem(IItemConvertible itemConvertible) 
	{
		getCollection().add(itemConvertible.toItem(this));
	}

	public void addItem(IItem item) 
	{
		getCollection().add(item);
	}
	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET + 
					 ICMDBfServicesConstants.CMDBF_PREFIX +
					 IQueryTransformerConstants.NODES_ELEMENT+" "+IQueryTransformerConstants.TEMPLATE_ID_ATTRIBUTE+"=\""+getId()+ICMDBfServicesConstants.DOUBLE_QUOTE+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, getCollection());
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + IQueryTransformerConstants.NODES_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	public int getType()
	{		
		return IQueryServiceElementCollection.NODES;
	}
	
	public IItemTemplate getItemTemplate()
	{
		return (IItemTemplate)getTemplate();
	}

}
