/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.ISelectedRecordType;

/**
 * Interface representing the <contentSelector> element of the query structure
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IContentSelector extends IXMLWritable {
	/**
	 * Add a record type to the set of record types being requested as part of the query
	 * 
	 * @param recordType
	 */
	public void addSelectedRecordType(ISelectedRecordType recordType);

	/**
	 * Answer an array of record types that are being requested to be returned in the query result
	 * @return
	 */
	public ISelectedRecordType[] getSelectedRecordTypes();

	/**
	 * Set whether returned record content must match the selected type.
	 * 
	 * @param matchedRecords
	 */
	public void setMatchedRecords(boolean matchedRecords);
	
	/**
	 * Answer whether returned record content must match the selected type
	 * 
	 * @return
	 */
	public boolean isMatchedRecords();
}
