/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRecordConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IXPathExpression;

/**
 * Abstract supertype of item template and relationship template types
 * containing common attributes
 * 
 * @provisional
 * @author David Whiteman
 */
public interface ITemplate {

	/**
	 * Answer the id for this template
	 * 
	 * @return
	 */
	public String getId();

	/**
	 * Set the id for this template
	 * 
	 * @param id
	 */
	public void setId(String id);

	/**
	 * Answer whether this template should be suppressed from the results
	 * 
	 * @return true if this template should be suppressed from the query result;
	 *         false otherwise
	 */
	public boolean isSuppressFromResult();

	/**
	 * Sets whether the template results should be suppressed
	 * 
	 * @param suppress
	 *            Indicates whether the template results should be suppressed
	 *            from the query result
	 */
	public void setSuppressFromResult(boolean suppress);

	/**
	 * Answer the content selector, if any, for the receiver
	 * 
	 * @return
	 */
	public IContentSelector getContentSelector();

	/**
	 * Set a content selector for the receiver
	 * 
	 * @param contentSelector
	 */
	public void setContentSelector(IContentSelector contentSelector);

	/**
	 * Answer the instance id constraint for the receiver
	 * 
	 * @return
	 */
	public IInstanceIdConstraint getInstanceIdConstraint();

	/**
	 * Set the instance id constraint for the receiver
	 * 
	 * @param instanceIdConstraint
	 */
	public void setInstanceIdConstraint(
			IInstanceIdConstraint instanceIdConstraint);

	/**
	 * Answer the set of record constraints being used to retrieve an item or
	 * relationship
	 * 
	 * @return
	 */
	public IRecordConstraint[] getRecordConstraints();

	/**
	 * Answer the set of xpath expressions being used to retrieve an item or
	 * relationship
	 * 
	 * @return
	 */
	public IXPathExpression[] getXpathExpressions();

	/**
	 * Add a record constraint to the receiver
	 * 
	 * @param recordConstraint
	 */
	public void addRecordConstraint(IRecordConstraint recordConstraint);

	/**
	 * Add an xpath expression to the receiver
	 * 
	 * @param xpathExpression
	 */
	public void addXpathExpression(IXPathExpression xpathExpression);

}
