/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * Interface for <edges> elements in the query service <queryResponse>
 * structure.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IEdges extends IQueryServiceElementCollection
{
	/**
	 * Adds a relationship that the convertible maps to
	 * 
	 * @param relationshipConvertible The relationship convertible whose
	 * mapped relationship is added
	 */
	public void addRelationship(IRelationshipConvertible relationshipConvertible);
	
	
	/**
	 * Adds relationship to the Edges instance
	 * 
	 * @param relationship The relationship to be added
	 */
	public void addRelationship(IRelationship relationship);
	

}
