/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;

/**
 * An object of this type is capable of converting itself to an 
 * object of type {@link IItem}
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IItemConvertible {
	/**
	 * Converts this object to an {@link IItem}.  
	 * 
	 * If the implementor of this interface happens to also
	 * implement {@link IItem}, then the method should return the
	 * receiver (i.e. <tt>this</tt>).
	 * 
	 * @param parent The parent
	 * @return An {@link IItem} representing this object
	 */
	public IItem toItem(INodes parent);
}
