/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Interface representing an object graph equivalent to the <queryResult>
 * element of the CMDBf query service.
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IQueryResult extends IXMLWritable, IRootElement {
	/**
	 * Answer all Nodes children of the receiver.
	 * 
	 * @return
	 */
	public INodes[] getAllNodes();

	/**
	 * Answer the INodes instance with a templateId of <tt>id</tt>
	 * 
	 * @param id template id of INodes being fetched
	 * @return
	 */
	public INodes getNodes(String id);

	/**
	 * Answer all Edges children of the receiver.
	 * 
	 * @return
	 */
	public IEdges[] getAllEdges();

	/**
	 * Answer the IEdges instance with a templateId of <tt>id</tt>
	 * 
	 * @param id template id of IEdges being fetched
	 * @return
	 */
	public IEdges getEdges(String id);

	/**
	 * Add an INodes child to the receiver
	 * 
	 * @param nodes
	 */
	public void addNodes(INodes nodes);

	/**
	 * Remove an INodes child from the receiver
	 * 
	 * @param nodes
	 */
	public void removeNodes(INodes nodes);

	/**
	 * Add an IEdges child to the receiver
	 * 
	 * @param edges
	 */
	public void addEdges(IEdges edges);

	/**
	 * Remove an IEdges child from the receiver
	 * 
	 * @param edges
	 */
	public void removeEdges(IEdges edges);
}
