/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.query.transform.artifacts.IContentSelector;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElementCollection;

/**
 * Specialized graph element collection for the needs
 * of the query service.
 *
 * @provisional
 * @see INodes
 * @see IEdges
 * @author David Whiteman
 */
public interface IQueryServiceElementCollection extends IGraphElementCollection 
{
	/**
	 * Indicates that this collection represents a set of nodes
	 * in a graph query response 
	 */
	public static final int NODES = 0x01;
	
	/**
	 * Indicates that this collection represents a set of relationships
	 * in a graph query response
	 */
	public static final int RELATIONSHIPS = 0x02;

		
	/**
	 * Returns the ID of this graph element collection
	 * 
	 * @return The id of this graph element collection
	 */
	public String getId();	
	
	
	/**
	 * Returns the type of this graph element collection
	 * 
	 * @return The type of this graph element collection
	 */
	public int getType();

	/**
	 * Returns the directives that are associated with this
	 * graph element collection.
	 * 
	 * @return The directives associated with this graph element
	 * collection
	 */
	public IContentSelector getDirectives();


	/**
	 * This flag is used to indicate that the context corresponds
	 * to all items or relationships stored in a repository.  This
	 * is useful when evaluating the first constraint associated with
	 * a template.
	 * 
	 * @return true if this is the starting context; false otherwise
	 */
	public boolean isStartingContext();
	
	
	/**
	 * Sets a flag to indicate  if this collection is the starting
	 * context
	 * 
	 * @param startingContext The starting context
	 */
	public void setStartingContext (boolean startingContext);
}
