/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts;

import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts.Edges;
import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts.Item;
import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts.Nodes;
import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts.QueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.internal.query.transform.response.artifacts.Relationship;
import org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.QueryInputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;

/**
 * Factory for creating concrete instances for the API interfaces
 * of query response graph objects.  This factory creates the artifacts
 * supplied by default by the CMDBf services framework.  Developers can
 * supply their own implementation of IQueryOutputArtifactFactory as an
 * argument to the operations and transformers.
 * 
 * @provisional
 * @author David Whiteman
 */
public class QueryOutputArtifactFactory implements IQueryOutputArtifactFactory
{
	private static IQueryOutputArtifactFactory instance;

	public static IQueryOutputArtifactFactory getInstance() {
		if (instance == null) {
			instance = new QueryOutputArtifactFactory();
		}

		return instance;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createEdges(java.lang.String)
	 */
	public IEdges createEdges(String templateId)
	{
		return new Edges(templateId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createEdges(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate)
	 */
	public IEdges createEdges(IRelationshipTemplate relationshipTemplate)
	{
		return new Edges(relationshipTemplate);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createEdges(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate, org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IRelationshipConvertible)
	 */
	public IEdges createEdges(IRelationshipTemplate relationshipTemplate, IRelationshipConvertible relationshipConvertible)
	{
		return new Edges(relationshipTemplate, relationshipConvertible);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createEdges(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate, java.util.List)
	 */
	public IEdges createEdges(IRelationshipTemplate relationshipTemplate, List<?> elements)
	{
		return new Edges(relationshipTemplate, elements);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createItem()
	 */
	public IItem createItem()
	{
		return new Item();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createNodes(java.lang.String)
	 */
	public INodes createNodes(String templateId)
	{
		return new Nodes(templateId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createNodes(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate)
	 */
	public INodes createNodes(IItemTemplate itemTemplate)
	{
		return new Nodes(itemTemplate);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createNodes(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate, org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IItemConvertible)
	 */
	public INodes createNodes(IItemTemplate itemTemplate, IItemConvertible itemConvertible)
	{
		return new Nodes(itemTemplate, itemConvertible);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createNodes(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate, java.util.List)
	 */
	public INodes createNodes(IItemTemplate itemTemplate, List<?> elements)
	{
		return new Nodes(itemTemplate, elements);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createQueryResult()
	 */
	public IQueryResult createQueryResult()
	{
		return new QueryResult();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createRelationship()
	 */
	public IRelationship createRelationship()
	{
		return new Relationship();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createInstanceId(java.lang.String, java.lang.String)
	 */
	public IInstanceId createInstanceId(String mdrId, String localId) {
		return CommonArtifactFactory.getInstance().createInstanceId(mdrId, localId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createRecord(org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement, java.lang.String)
	 */
	public IRecord createRecord(IGraphElement parent, String recordId)
	{		
		return CommonArtifactFactory.getInstance().createRecord(parent, recordId);
	}

	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createRecordMetadata()
	 */
	public IRecordMetadata createRecordMetadata ()
	{
		return CommonArtifactFactory.getInstance().createRecordMetadata();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createItemTemplate(java.lang.String)
	 */
	public IItemTemplate createItemTemplate(String id)
	{
		return QueryInputArtifactFactory.getInstance().createItemTemplate(id);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory#createRelationshipTemplate(java.lang.String)
	 */
	public IRelationshipTemplate createRelationshipTemplate(String id)
	{
		return QueryInputArtifactFactory.getInstance().createRelationshipTemplate(id);
	}
}
