/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.mdr.api;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.dc.mdr.exception.CMDBfException;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.w3c.dom.Element;

@ManagedResourceCapability(namespace=IMdrQuery.NAMESPACE_URI)
public interface IMdrQuery {
	public static final String NAMESPACE_URI = "http://www.eclipse.org/cosmos/mdrquery";
	
	String PREFIX = "mdr";
	
	String QUERY_OP_URI = NAMESPACE_URI + "/graphQuery";
	QName QUERY_OP_QNAME = new QName(NAMESPACE_URI, "graphQuery", PREFIX);
	QName QUERY_REQUEST_QNAME = new QName(NAMESPACE_URI, "queryRequest", PREFIX);
	
	@ManagedOperation
	public Element graphQuery(Element queryRequest) throws CMDBfException;

}
