/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr;

import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.QueryMetadataTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IQueryServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.dataManager.api.DataManagerPolicyAssertion;
import org.eclipse.cosmos.dc.mdr.api.IMdrQuery;
import org.eclipse.cosmos.dc.mdr.impl.AbstractMdr;
import org.eclipse.cosmos.me.management.annotations.ManagedResource;
import org.eclipse.cosmos.me.management.provisional.wsdm.PolicyAssertion;
import org.eclipse.cosmos.samples.cmdbf.services.query.ICMDBfSampleConstants;
import org.eclipse.cosmos.samples.cmdbf.services.query.QueryHandlerFactory;
import org.eclipse.cosmos.samples.cmdbf.services.query.XMLRepository;

@ManagedResource
public class ExampleMdr extends AbstractMdr implements IDataManager, IMdrQuery 
{
	static final String EXAMPLE_METADATA_FILE = "META-INF/MetadataExample.xml";
	
	public ExampleMdr() 
	{
		Map<String, Object> context = new Hashtable<String, Object>();
		try {
			context.put(ICMDBfSampleConstants.DATA_PROVIDER, new XMLRepository());
		} catch (Exception e) {
			e.printStackTrace();
		}
		getQueryOperation().initialize(context);
	}

	@Override
	public IQueryHandlerFactory getQueryHandlerFactory() 
	{
		return QueryHandlerFactory.getInstance();
	}

	
	/**
	 * Get the policy assertions of the Data Manager. 
	 *   
	 * Override this method to add your policy assertions (ie: for MDR metadata) to your WSDL
	 *  
	 * @return Collection<PolicyAssertion>
	 */
	@Override
	public Collection<PolicyAssertion> getPolicyAssertions() {
		
		ArrayList<PolicyAssertion> policyAssertionList = new ArrayList<PolicyAssertion>();
		
		URL exampleMetadataURL = Thread.currentThread().getContextClassLoader().getResource(EXAMPLE_METADATA_FILE);

		try {
			// read example metadata from configuration file
			IQueryServiceMetadata queryServiceMetadata = QueryMetadataTransformer.transform(exampleMetadataURL.openStream());
			
			StringWriter sw = new StringWriter();
			queryServiceMetadata.toXML( sw, 0 );
			String metadata = sw.toString();
			
			// create a DataManagerPolicyAssertion containing the example metadata
			PolicyAssertion metadataPolicyAssertion = new DataManagerPolicyAssertion( "SupportedMetadata", metadata, null);
			
			// add it to the array of policy assertions
			policyAssertionList.add(metadataPolicyAssertion);
			
		} catch (Exception e) {
			System.out.println( "Error with " + exampleMetadataURL.toString() + " : " + e.getMessage() );
		}
		
		return policyAssertionList;
	}

}
