/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
// 
// MyServiceProxy.java
// Wed Dec 26 15:53:53 EST 2007
// Generated by the Apache Muse Code Generation Tool
// 
package org.eclipse.cosmos.dc.management.domain.client;

import org.apache.muse.core.proxy.ProxyHandler;
import java.util.Map;
import org.w3c.dom.Element;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.apache.muse.core.Environment;
import java.net.URI;
import org.apache.muse.core.proxy.ReflectionProxyHandler;
import java.util.HashMap;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.WsaConstants;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.apache.muse.ws.resource.sg.remote.ServiceGroupClient;

import javax.xml.namespace.QName;

public class ManagementDomainClient extends ServiceGroupClient implements IManagementDomainClient
{

    public URI getResourceId()
        throws SoapFault
    {
        URI[] results = (URI[])getPropertyAsObject(PROPERTIES[0], URI.class);
        return results.length == 0 ? null : results[0];
    }

    public String[] getDescription()
        throws SoapFault
    {
        return (String[])getPropertyAsObject(PROPERTIES[1], String.class);
    }

    public void insertDescription(String value)
        throws SoapFault
    {
        insertResourceProperty(PROPERTIES[1], new Object[]{ value });
    }

    public void updateDescription(String value)
        throws SoapFault
    {
        updateResourceProperty(PROPERTIES[1], new Object[]{ value });
    }

    public void deleteDescription()
        throws SoapFault
    {
        deleteResourceProperty(PROPERTIES[1]);
    }

    public String getVersion()
        throws SoapFault
    {
        String[] results = (String[])getPropertyAsObject(PROPERTIES[2], String.class);
        return results.length == 0 ? null : results[0];
    }

    public String[] getCaption()
        throws SoapFault
    {
        return (String[])getPropertyAsObject(PROPERTIES[3], String.class);
    }

    public void insertCaption(String value)
        throws SoapFault
    {
        insertResourceProperty(PROPERTIES[3], new Object[]{ value });
    }

    public void updateCaption(String value)
        throws SoapFault
    {
        updateResourceProperty(PROPERTIES[3], new Object[]{ value });
    }

    public void deleteCaption()
        throws SoapFault
    {
        deleteResourceProperty(PROPERTIES[3]);
    }

    public URI[] getManageabilityCapability()
        throws SoapFault
    {
        return (URI[])getPropertyAsObject(PROPERTIES[4], URI.class);
    }


    public void register()
        throws SoapFault
    {
        Object[] params = new Object[0];

        ProxyHandler handler = getHandler("register");
        invoke(handler, params);
    }


    public String[] getAllServices()
        throws SoapFault
    {
        Object[] params = new Object[0];

        ProxyHandler handler = getHandler("getAllServices");
        return (String[])invoke(handler, params);
    }


    public String[] getServices(QName property, String value)
        throws SoapFault
    {
        Object[] params = new Object[2];

        params[0] = property;
        params[1] = value;

        ProxyHandler handler = getHandler("getServices");
        return (String[])invoke(handler, params);
    }

    public Element getOperationalStatus()
        throws SoapFault
    {
        Element[] results = (Element[])getPropertyAsObject(PROPERTIES[5], Element.class);
        return results.length == 0 ? null : results[0];
    }

    private static final String[] _METHOD_NAMES = {
        "register", "getAllServices", "getServices"
    };

    private static final Class[] _RETURN_TYPES = {
        void.class, String[].class, String[].class
    };

    private static final String[] _ACTIONS = {
        "http://www.eclipse.org/cosmos/broker/RegisterRequest", "http://www.eclipse.org/cosmos/broker/GetAllServicesRequest", "http://www.eclipse.org/cosmos/broker/GetServicesRequest"
    };

    private static final QName[] _REQUEST_NAMES = {
        new QName("http://www.eclipse.org/cosmos/broker", "register", "pfx0"), new QName("http://www.eclipse.org/cosmos/broker", "getAllServices", "pfx0"), new QName("http://www.eclipse.org/cosmos/broker", "getServices", "pfx0")
    };

    private static final QName[] _RESPONSE_NAMES = {
        null, new QName("http://www.eclipse.org/cosmos/broker", "getAllServicesResponse", "pfx0"), new QName("http://www.eclipse.org/cosmos/broker", "getServicesResponse", "pfx0")
    };

    private static final QName[][] _REQUEST_PARAM_NAMES = {
        {

        },
        {

        },
        {
            new QName("http://www.eclipse.org/cosmos/broker", "property", "pfx0"),
            new QName("http://www.eclipse.org/cosmos/broker", "value", "pfx0")
        }
    };
    public ManagementDomainClient(EndpointReference param0, EndpointReference param1)    {
        super(param0, param1);
    }

    public ManagementDomainClient(EndpointReference param0, EndpointReference param1, Environment param2)    {
        super(param0, param1, param2);
    }

    public ManagementDomainClient(EndpointReference param0, EndpointReference param1, SoapClient param2)    {
        super(param0, param1, param2);
    }

    public ManagementDomainClient(EndpointReference param0)    {
        super(param0);
    }

    protected ProxyHandler getHandler(String methodName)
    {
        return (ProxyHandler)_HANDLERS_BY_NAME.get(methodName);
    }

    private static final Map _HANDLERS_BY_NAME = new HashMap();

    static
    {
        for (int n = 0; n < _METHOD_NAMES.length; ++n)
        {
            ProxyHandler handler = new ReflectionProxyHandler();
            handler.setAction(_ACTIONS[n]);
            handler.setRequestName(_REQUEST_NAMES[n]);
            handler.setRequestParameterNames(_REQUEST_PARAM_NAMES[n]);
            handler.setResponseName(_RESPONSE_NAMES[n]);
            handler.setReturnType(_RETURN_TYPES[n]);

            _HANDLERS_BY_NAME.put(_METHOD_NAMES[n], handler);
        }
    }

	public String[] getBrokers() throws SoapFault {
		return getAllServices();
	}
	
	@Deprecated
    public String getBroker() throws SoapFault {
    	String[] eprs = getAllServices();
    	if (eprs != null && eprs.length > 0) {
    		return eprs[0];
    	}
    	return null;
    }

	
	@Deprecated
	public boolean registerBroker(String endpointAddress, String resourceId,
			String name) throws SoapFault {
		EndpointReference epr = new EndpointReference(URI.create(endpointAddress));
		epr.addParameter(WsaConstants.DEFAULT_RESOURCE_ID_QNAME, resourceId);
		WsResourceClient resourceClient = add(epr, null);
		return (resourceClient != null) ? true : false;
	}}
