/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA Inc. - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.Textarea");

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.query.RegisterPartialDialog",
	// superclass	
   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
	{
		labelDialogQuery:"",
		registrationService:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/RegistrationOutputter",		
		brokerService:"json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/BrokerOutputter",		
		builder:null,
		
		bindInput: function(data, callbackMethod){	

	   		var _self = this;
			console.debug("HEREWadsjfwerADFDSFDFFD");
    		data.getResponse[0]({item:data,onItem:function(response){    	
    			console.debug("HEREWadsjfwer");
	    		_self.builder = new org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog({callback: callbackMethod, registrationService: _self.registrationService, brokerService:_self.brokerService, labelQuery:_self.labelDialogQuery, title:_self.title, epr:data.epr, queryResp:response, UIContext:_self.UIContext});
	    		_self.builder.show();		
    		}
			});

		},
		
		render: function(input){
			this.builder.destroy();
			this.builder = null;
			return input;
		}
	}
); 

 dojo.declare(
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog",
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
	 	rows:12,
	 	cols:80,
		labelQuery:"",	 	
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/RegisterPartialDialog.html"),
		widgetsInTemplate: true,
		widgetId: "registerPartialDialog",
		gridWidget: null,
		cmdbfWidget: null,
		cmdbflist: null,
		cmdbfEPR: null,
		mdrEPR: null,		
		cilist: null,
		cis: null,
		mode: "register",
		
		show: function(){
			this.dialogBox.show();
		},
		destroy: function(){
			var tempWidget = dijit.byId("registerGrid");
			if ( tempWidget ){
				tempWidget.destroy();
			}
			
			var tempButton = dijit.byId("regbutton");
			if ( tempButton ){
				tempButton.destroy();
			}
			
			var tempWidget = dijit.byId("cmdbfGrid");
			if ( tempWidget ){
				tempWidget.destroy();
			}
			
			if ( this.dialogBox ){
				this.dialogBox.destroy();
			}

			this.inherited(arguments);
		},
		
		onRegister: function(){
			var logger = new org.eclipse.cosmos.provisional.dr.ps.components.utility.ErrorHandler();

			if ( cmdbfWidget.selection.getSelectedCount() == 0 ){
				logger.logWarning("Please select a CMDBf",true);
			} else if ( cmdbfWidget.selection.getSelectedCount() > 1 ){
				logger.logWarning("Please select a single CMDBf",true);
			} else if ( gridWidget.selection.getSelectedCount() > 0 ){

				//
				// build the selected CMDBf EPR parameter for the outputter
				//
				var cmdbfselect = cmdbfWidget.selection.getSelected();
				var index = cmdbfselect[0];
				var cmdbf = cmdbflist[index];
				this.cmdbfEPR = cmdbf[1];
				console.debug(this.cmdbfEPR);
				//
				// build the selected CIs parameters for the outputter
				//
				var selection = gridWidget.selection.getSelected();
				this.cis = "";
				for(var i=0, l=selection.length; i<l; i++){
					var index = selection[i];
					var ci = cilist[index];
					this.cis += "&localid" + i + "=" + ci[1];
				}
				
				var _self= this;
				// re-populate the grid with the registration results
				var postData = "cmd=" + this.mode + "&queryResp=" + escape(this.queryResp) + "&cmdbfEPR="+this.cmdbfEPR + "&mdrEPR="+this.mdrEPR + this.cis;
				this.UIContext.submitQuery(
						
					// invoke the Registration outputter to register the items 
					{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:_self.registrationService, postData:postData}), 
					onItem:function(response){
											
		                // define the grid view with columns 
		                var regview = {
		                        cells: [[
				                        {name: "LocalId",     field: 0, width: "400px"},
			                            {name: "accepted/declined", field: 1, width: "100px" }
		                          ]
		                        ]
		                };
		                // define the grid layout containing the view
		                var reglayout = [ regview ];
						
						// create a model from the outputter JSON response
						var regmodel = new dojox.grid.data.Table(null, response);
						
						gridWidget.autoHeight = true;	// turn on autoHeight
						gridWidget.autoWidth = true;	// turn on autoWidth
		
						// set the grid model
						gridWidget.setModel( regmodel );
		
						// set the grid layout
						gridWidget.setStructure(reglayout);
								
						// redraw the grid
						gridWidget.render();
								
					}, queryProp:"query"}
				);
				
				var regbutton = dijit.byId("regbutton");
				regbutton.disabled = true;
							
			} else {
				logger.logWarning("No configuration items have been selected",true);
			}
		},
		
		onCancel: function(){
			this.dialogBox.onCancel();
			this.destroy();
		},
		
		postMixInProperties: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog.superclass.postMixInProperties.apply(this, arguments);
		},
		
		postCreate: function(){
			//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterPartialDialog.superclass.postCreate.apply(this, arguments);
			var idLength = this.id.length;
			var index =  this.id.substring(idLength-2, idLength);
			this.dialogBox = dijit.byId(this.widgetId);
			this.cmdbfEPR = this.epr;
			this.mdrEPR = this.epr;
						
            // get the cmdbf widget from the page
			cmdbfWidget = dijit.byId("cmdbfGrid");
			var _self= this;

			if ( this.title.substr( 0, 5 ) == "Dereg" ){
				this.mode = "deregister";
				
				var regbutton = dijit.byId("regbutton");
				regbutton.setLabel( "Deregister" );
			}
			
			// populate the grid with CMDBfs
			this.UIContext.submitQuery(
					
				// invoke the Broker outputter to return a list of CMDBfs to the onItem callback function
				{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:_self.brokerService+"&query=cmdbf&epr="+escape(this.epr)}), 
				onItem:function(response){
					
					cmdbflist = response;
					
	                // define the grid view with columns 
	                var cmdbfview = {
	                        cells: [[
		                            {name: 'Select CMDBf:', field: 0, width: "508px"}
	                          ]
	                        ]
	                };
	                // define the grid layout containing the view
	                var cmdbflayout = [ cmdbfview ];
					
					// create a model from the outputter JSON response
					var cmdbfmodel = new dojox.grid.data.Table(null, response);
					
					cmdbfWidget.autoHeight = true;	// turn on autoHeight
					cmdbfWidget.autoWidth = true;	// turn on autoWidth

					// set the grid model
					cmdbfWidget.setModel( cmdbfmodel );
	
					// set the grid layout
					cmdbfWidget.setStructure(cmdbflayout);

					// redraw the grid
					cmdbfWidget.render();

				}, queryProp:"query"}
			);
			
			
            // get the grid widget from the page
			gridWidget = dijit.byId("registerGrid");
			var _self= this;
			
			var postData = "cmd=query&queryResp=" + escape(this.queryResp) + "&mdrepr="+escape(this.mdrEPR);
			// populate the grid with CIs
			this.UIContext.submitQuery(
					
				// invoke the Registration outputter to query a list of CIs 
				{queryObject:new org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery({queryHandler:_self.registrationService, postData:postData}), 
				onItem:function(response){
					
					cilist = response;
					
	                // define the grid view with columns 
	                var regview = {
	                				cells: [
	                				        [
	                				         {name: 'Type', field: 0, width: "30px"}, 
	                				         {name: 'LocalId', field: 1, width: "470px"}
	                				        ]
	                				       ]
	                			  };
	                
	                // define the grid layout containing the view
	                var reglayout = [ regview ];
					
					// create a model from the outputter JSON response
					var regmodel = new dojox.grid.data.Table(null, response);
					
					gridWidget.autoHeight = true;	// turn on autoHeight
					gridWidget.autoWidth = true;	// turn on autoWidth

					// set the grid model
					gridWidget.setModel( regmodel );
	
					// set the grid layout
					gridWidget.setStructure(reglayout);

					// redraw the grid
					gridWidget.render();

				}, queryProp:"query"}
			);
			
		}
		
	}
);      
