/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.dataManager.client;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.apache.muse.ws.metadata.remote.MetadataExchangeClient;
import org.apache.muse.ws.resource.remote.WsResourceClient;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.dc.dataManager.exception.DataManagerException;
import org.w3c.dom.Element;

/**
 * Client proxy of the data manager. 
 *
 */
public class DataManagerClient extends WsResourceClient {

	public DataManagerClient(EndpointReference destination) {
		super(destination);
		
	}
	
	public void register() throws DataManagerException {
		Element soapBody = XmlUtils.createElement(IDataManager.REGISTER_OP_QNAME);
		
		try {
			Element result = invoke(IDataManager.REGISTER_OP_URI, soapBody);
		} catch (SoapFault e) {
			throw new DataManagerException(e);
		}
	}

	public void deregister() throws DataManagerException {
		Element soapBody = XmlUtils.createElement(IDataManager.DEREGISTER_OP_QNAME);
		
		try {
			Element result = invoke(IDataManager.DEREGISTER_OP_URI, soapBody);
		} catch (SoapFault e) {
			throw new DataManagerException(e);
		}
	}

	public Element getWSDL() throws DataManagerException{
	    MetadataExchangeClient mexClient = new MetadataExchangeClient( getEndpointReference() );
	    
	    try {
	    	return mexClient.getWSDL();
		} catch (SoapFault e) {
			throw new DataManagerException(e);
		}
	}
}
