/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IDialect;


public class Dialect implements IDialect 
{
	private String dialect = null;

	
	/**
	 * set the dialect 
	 * 
	 * @param dialect
	 */
	public void setDialect(String dialect){
		this.dialect = dialect;
	}
		
	/**
	 * Retrieve the dialect
	 * 
	 * @return dialect
	 */
	public String getDialect(){
		return dialect;
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ServiceMetadataConstants.DIALECT_ELEMENT));
		
		if ( dialect != null){
			writer.write(dialect);
		}
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.DIALECT_ELEMENT)+ICMDBfServicesConstants.nl);
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Dialect other = (Dialect) obj;
		if (dialect == null) {
			if (other.dialect != null)
				return false;
		} else if (!dialect.equals(other.dialect))
			return false;

		return true;
	}
	
}
